/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class SSH {
    protected final Session session;

    public SSH(Session session) {
        this.session = session;
    }

    public boolean execSyncCommand(String command) throws JSchException, IOException {
        return this.execSyncCommand(command, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execSyncCommand(String command, PrintStream stdoutConsumer, PrintStream stderrConsumer) throws JSchException, IOException {
        InputStream stdout = null;
        InputStream stderr = null;
        Channel channel = null;
        try {
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.setInputStream(null);
            stdout = channel.getInputStream();
            stderr = ((ChannelExec)channel).getErrStream();
            channel.connect();
            int exitCode = this.consumeOutputSyncAndReturnExitCode(channel, stdout, stdoutConsumer, stderr, stderrConsumer);
            boolean bl = exitCode == 0;
            return bl;
        }
        finally {
            if (stdout != null) {
                stdout.close();
            }
            if (stderr != null) {
                stderr.close();
            }
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    protected int consumeOutputSyncAndReturnExitCode(Channel channel, InputStream stdout, PrintStream stdoutConsumer, InputStream stderr, PrintStream stderrConsumer) throws IOException {
        byte[] tmp = new byte[102400];
        while (true) {
            this.consumeStream(tmp, stdout, stdoutConsumer);
            this.consumeStream(tmp, stderr, stderrConsumer);
            if (channel.isClosed()) {
                return channel.getExitStatus();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }

    protected void consumeStream(byte[] buffer, InputStream in, PrintStream out) throws IOException {
        int length;
        while (in.available() > 0 && (length = in.read(buffer, 0, buffer.length)) >= 0) {
            if (out == null) continue;
            out.print(new String(buffer, 0, length));
        }
    }
}

