/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import cc.arduino.contributions.libraries.LibraryInstaller;
import cc.arduino.contributions.libraries.ui.ContributedLibraryTableCell;
import cc.arduino.contributions.libraries.ui.DropdownInstalledLibraryItem;
import cc.arduino.contributions.libraries.ui.DropdownLibraryOfCategoryItem;
import cc.arduino.contributions.libraries.ui.DropdownLibraryOfTypeItem;
import cc.arduino.contributions.libraries.ui.LibrariesIndexTableModel;
import cc.arduino.contributions.ui.DropdownAllItem;
import cc.arduino.contributions.ui.DropdownItem;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import cc.arduino.contributions.ui.InstallerJDialog;
import cc.arduino.contributions.ui.InstallerJDialogUncaughtExceptionHandler;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.utils.Progress;
import com.google.common.base.Predicate;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import processing.app.I18n;

public class LibraryManagerUI
extends InstallerJDialog<ContributedLibrary> {
    private LibrariesIndexer indexer;
    private final JComboBox typeChooser;
    private Predicate<ContributedLibrary> typeFilter;
    protected final ActionListener typeChooserActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            DropdownItem selected = (DropdownItem)LibraryManagerUI.this.typeChooser.getSelectedItem();
            if (LibraryManagerUI.this.typeFilter == null || !LibraryManagerUI.this.typeFilter.equals((Object)selected)) {
                LibraryManagerUI.this.typeFilter = selected.getFilterPredicate();
                if (LibraryManagerUI.this.contribTable.getCellEditor() != null) {
                    LibraryManagerUI.this.contribTable.getCellEditor().stopCellEditing();
                }
                LibraryManagerUI.this.updateIndexFilter(LibraryManagerUI.this.filters, (Predicate<ContributedLibrary>[])new Predicate[]{LibraryManagerUI.this.categoryFilter, LibraryManagerUI.this.typeFilter});
            }
        }
    };
    private LibraryInstaller installer;
    private Thread installerThread = null;

    @Override
    protected FilteredAbstractTableModel createContribModel() {
        return new LibrariesIndexTableModel();
    }

    private LibrariesIndexTableModel getContribModel() {
        return (LibrariesIndexTableModel)this.contribModel;
    }

    @Override
    protected InstallerTableCell createCellRenderer() {
        return new ContributedLibraryTableCell();
    }

    @Override
    protected InstallerTableCell createCellEditor() {
        return new ContributedLibraryTableCell(){

            @Override
            protected void onInstall(ContributedLibrary selectedLibrary, ContributedLibrary installedLibrary) {
                if (selectedLibrary.isReadOnly()) {
                    LibraryManagerUI.this.onRemovePressed(installedLibrary);
                } else {
                    LibraryManagerUI.this.onInstallPressed(selectedLibrary, installedLibrary);
                }
            }

            @Override
            protected void onRemove(ContributedLibrary library) {
                LibraryManagerUI.this.onRemovePressed(library);
            }
        };
    }

    public LibraryManagerUI(Frame parent) {
        super(parent, "Library Manager", Dialog.ModalityType.APPLICATION_MODAL, I18n._((String)"Unable to reach Arduino.cc due to possible network issues."));
        this.filtersContainer.add((Component)new JLabel(I18n._((String)"Topic")), 1);
        this.filtersContainer.remove(2);
        this.typeChooser = new JComboBox();
        this.typeChooser.setMaximumRowCount(20);
        this.typeChooser.setEnabled(false);
        this.filtersContainer.add(Box.createHorizontalStrut(5), 0);
        this.filtersContainer.add((Component)new JLabel(I18n._((String)"Type")), 1);
        this.filtersContainer.add(Box.createHorizontalStrut(5), 2);
        this.filtersContainer.add((Component)this.typeChooser, 3);
    }

    @Override
    public void updateIndexFilter(String[] filters, Predicate<ContributedLibrary> ... additionalFilters) {
        if (additionalFilters.length == 1) {
            additionalFilters = new Predicate[]{additionalFilters[0], this.typeFilter};
        }
        super.updateIndexFilter(filters, additionalFilters);
    }

    public void setIndexer(LibrariesIndexer indexer) {
        this.indexer = indexer;
        DropdownItem previouslySelectedCategory = (DropdownItem)this.categoryChooser.getSelectedItem();
        DropdownItem previouslySelectedType = (DropdownItem)this.typeChooser.getSelectedItem();
        this.categoryChooser.removeActionListener(this.categoryChooserActionListener);
        this.typeChooser.removeActionListener(this.typeChooserActionListener);
        this.getContribModel().setIndexer(indexer);
        this.categoryFilter = null;
        this.categoryChooser.removeAllItems();
        this.categoryChooser.addItem(new DropdownAllItem());
        List categories = indexer.getIndex().getCategories();
        for (String category : categories) {
            this.categoryChooser.addItem(new DropdownLibraryOfCategoryItem(category));
        }
        this.categoryChooser.setEnabled(this.categoryChooser.getItemCount() > 1);
        this.categoryChooser.addActionListener(this.categoryChooserActionListener);
        if (previouslySelectedCategory != null) {
            this.categoryChooser.setSelectedItem(previouslySelectedCategory);
        } else {
            this.categoryChooser.setSelectedIndex(0);
        }
        this.typeFilter = null;
        this.typeChooser.removeAllItems();
        this.typeChooser.addItem(new DropdownAllItem());
        this.typeChooser.addItem(new DropdownInstalledLibraryItem(indexer.getIndex()));
        List types = indexer.getIndex().getTypes();
        for (String type : types) {
            this.typeChooser.addItem(new DropdownLibraryOfTypeItem(type));
        }
        this.typeChooser.setEnabled(this.typeChooser.getItemCount() > 1);
        this.typeChooser.addActionListener(this.typeChooserActionListener);
        if (previouslySelectedType != null) {
            this.typeChooser.setSelectedItem(previouslySelectedType);
        } else {
            this.typeChooser.setSelectedIndex(0);
        }
        this.filterField.setEnabled(this.contribModel.getRowCount() > 0);
        this.installer = new LibraryInstaller(indexer){

            public void onProgress(Progress progress) {
                LibraryManagerUI.this.setProgress(progress);
            }
        };
    }

    public LibrariesIndexer getIndexer() {
        return this.indexer;
    }

    public void setProgress(Progress progress) {
        this.progressBar.setValue(progress);
    }

    @Override
    protected void onCancelPressed() {
        super.onUpdatePressed();
        if (this.installerThread != null) {
            this.installerThread.interrupt();
        }
    }

    @Override
    protected void onUpdatePressed() {
        super.onUpdatePressed();
        this.installerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LibraryManagerUI.this.setProgressVisible(true, "");
                    LibraryManagerUI.this.installer.updateIndex();
                    LibraryManagerUI.this.onIndexesUpdated();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    LibraryManagerUI.this.setProgressVisible(false, "");
                }
            }
        });
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    public void onInstallPressed(final ContributedLibrary lib, final ContributedLibrary replaced) {
        this.clearErrorMessage();
        this.installerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LibraryManagerUI.this.setProgressVisible(true, I18n._((String)"Installing..."));
                    LibraryManagerUI.this.installer.install(lib, replaced);
                    LibraryManagerUI.this.onIndexesUpdated();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    LibraryManagerUI.this.setProgressVisible(false, "");
                }
            }
        });
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    public void onRemovePressed(final ContributedLibrary lib) {
        int chosenOption;
        boolean managedByIndex = this.indexer.getIndex().getLibraries().contains(lib);
        if (!managedByIndex && (chosenOption = JOptionPane.showConfirmDialog(this, I18n._((String)"This library is not listed on Library Manager. You won't be able to resinstall it from here.\nAre you sure you want to delete it?"), I18n._((String)"Please confirm library deletion"), 0, 3)) != 0) {
            return;
        }
        this.clearErrorMessage();
        this.installerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LibraryManagerUI.this.setProgressVisible(true, I18n._((String)"Removing..."));
                    LibraryManagerUI.this.installer.remove(lib);
                    LibraryManagerUI.this.onIndexesUpdated();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    LibraryManagerUI.this.setProgressVisible(false, "");
                }
            }
        });
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    protected void onIndexesUpdated() throws Exception {
    }
}

