/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.compress.utils.IOUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;

public class GPGDetachedSignatureVerifier {
    private String keyId;

    public GPGDetachedSignatureVerifier() {
        this("7F294291");
    }

    public GPGDetachedSignatureVerifier(String keyId) {
        this.keyId = keyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(File signedFile, File signature, File publicKey) throws IOException, PGPException {
        PGPPublicKey pgpPublicKey = this.readPublicKey(publicKey, this.keyId);
        FileInputStream signatureInputStream = null;
        FileInputStream signedFileInputStream = null;
        try {
            Object nextObject;
            signatureInputStream = new FileInputStream(signature);
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory((InputStream)signatureInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            try {
                nextObject = pgpObjectFactory.nextObject();
                if (!(nextObject instanceof PGPSignatureList)) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            PGPSignatureList pgpSignatureList = (PGPSignatureList)nextObject;
            assert (pgpSignatureList.size() == 1);
            PGPSignature pgpSignature = pgpSignatureList.get(0);
            pgpSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), pgpPublicKey);
            signedFileInputStream = new FileInputStream(signedFile);
            pgpSignature.update(IOUtils.toByteArray((InputStream)signedFileInputStream));
            boolean bl = pgpSignature.verify();
            return bl;
        }
        finally {
            if (signatureInputStream != null) {
                signatureInputStream.close();
            }
            if (signedFileInputStream != null) {
                signedFileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PGPPublicKey readPublicKey(File file, String keyId) throws IOException, PGPException {
        InputStream keyIn = null;
        try {
            keyIn = new BufferedInputStream(new FileInputStream(file));
            PGPPublicKey pGPPublicKey = this.readPublicKey(keyIn, keyId);
            return pGPPublicKey;
        }
        finally {
            if (keyIn != null) {
                keyIn.close();
            }
        }
    }

    private PGPPublicKey readPublicKey(InputStream input, String keyId) throws IOException, PGPException {
        PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Iterator keyRingIter = pgpPub.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIter.next();
            Iterator keyIter = keyRing.getPublicKeys();
            while (keyIter.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)keyIter.next();
                if (!Long.toHexString(key.getKeyID()).toUpperCase().endsWith(keyId)) continue;
                return key;
            }
        }
        throw new IllegalArgumentException("Can't find encryption key in key ring.");
    }
}

