/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.utils.network;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Observable;
import org.apache.commons.codec.binary.Base64;
import processing.app.PreferencesData;

public class FileDownloader
extends Observable {
    private Status status;
    private long initialSize;
    private Long downloadSize = null;
    private long downloaded;
    private final URL downloadUrl;
    private final File outputFile;
    private InputStream stream = null;
    private Exception error;

    public FileDownloader(URL url, File file) {
        this.downloadUrl = url;
        this.outputFile = file;
        this.downloaded = 0L;
        this.initialSize = 0L;
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public Long getDownloadSize() {
        return this.downloadSize;
    }

    public void setDownloadSize(Long downloadSize) {
        this.downloadSize = downloadSize;
        this.setChanged();
        this.notifyObservers();
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    private void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
        this.setChanged();
        this.notifyObservers();
    }

    public float getProgress() {
        if (this.downloadSize == null) {
            return 0.0f;
        }
        if (this.downloadSize == 0L) {
            return 100.0f;
        }
        return (float)this.downloaded / (float)this.downloadSize.longValue() * 100.0f;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws InterruptedException {
        RandomAccessFile file = null;
        try {
            int read;
            file = new RandomAccessFile(this.outputFile, "rw");
            this.initialSize = file.length();
            file.seek(this.initialSize);
            this.setStatus(Status.CONNECTING);
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
            System.getProperties().remove("https.proxyHost");
            System.getProperties().remove("https.proxyPort");
            System.getProperties().remove("http.proxyUser");
            System.getProperties().remove("http.proxyPassword");
            if (PreferencesData.has("proxy.http.server") && PreferencesData.get("proxy.http.server") != null && !PreferencesData.get("proxy.http.server").equals("")) {
                System.getProperties().put("http.proxyHost", PreferencesData.get("proxy.http.server"));
                System.getProperties().put("http.proxyPort", PreferencesData.get("proxy.http.port"));
            }
            if (PreferencesData.has("proxy.https.server") && PreferencesData.get("proxy.https.server") != null && !PreferencesData.get("proxy.https.server").equals("")) {
                System.getProperties().put("https.proxyHost", PreferencesData.get("proxy.https.server"));
                System.getProperties().put("https.proxyPort", PreferencesData.get("proxy.https.port"));
            }
            if (PreferencesData.has("proxy.user") && PreferencesData.get("proxy.user") != null && !PreferencesData.get("proxy.user").equals("")) {
                System.getProperties().put("http.proxyUser", PreferencesData.get("proxy.user"));
                System.getProperties().put("http.proxyPassword", PreferencesData.get("proxy.password"));
                System.getProperties().put("https.proxyUser", PreferencesData.get("proxy.user"));
                System.getProperties().put("https.proxyPassword", PreferencesData.get("proxy.password"));
            }
            Object connection = (HttpURLConnection)this.downloadUrl.openConnection();
            if (this.downloadUrl.getUserInfo() != null) {
                String auth = "Basic " + new String(new Base64().encode(this.downloadUrl.getUserInfo().getBytes()));
                ((URLConnection)connection).setRequestProperty("Authorization", auth);
            }
            ((URLConnection)connection).setRequestProperty("Range", "bytes=" + this.initialSize + "-");
            ((URLConnection)connection).setConnectTimeout(5000);
            this.setDownloaded(0L);
            ((URLConnection)connection).connect();
            int resp = ((HttpURLConnection)connection).getResponseCode();
            if (resp == 301 || resp == 302) {
                String newUrl = ((URLConnection)connection).getHeaderField("Location");
                connection = (HttpURLConnection)new URL(newUrl).openConnection();
                if (this.downloadUrl.getUserInfo() != null) {
                    String auth = "Basic " + new String(new Base64().encode(this.downloadUrl.getUserInfo().getBytes()));
                    ((URLConnection)connection).setRequestProperty("Authorization", auth);
                }
                ((URLConnection)connection).setRequestProperty("Range", "bytes=" + this.initialSize + "-");
                ((URLConnection)connection).setConnectTimeout(5000);
                ((URLConnection)connection).connect();
                resp = ((HttpURLConnection)connection).getResponseCode();
            }
            if (resp < 200 || resp >= 300) {
                throw new IOException("Recevied invalid http status code from server: " + resp);
            }
            long len = ((URLConnection)connection).getContentLength();
            if (len >= 0L) {
                this.setDownloadSize(len);
            }
            this.setStatus(Status.DOWNLOADING);
            FileDownloader fileDownloader = this;
            synchronized (fileDownloader) {
                this.stream = ((URLConnection)connection).getInputStream();
            }
            byte[] buffer = new byte[10240];
            while (this.status == Status.DOWNLOADING && (read = this.stream.read(buffer)) != -1) {
                file.write(buffer, 0, read);
                this.setDownloaded(this.getDownloaded() + (long)read);
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
            if (this.getDownloadSize() != null && this.getDownloaded() < this.getDownloadSize()) {
                throw new Exception("Incomplete download");
            }
            this.setStatus(Status.COMPLETE);
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCELLED);
            throw e;
        }
        catch (SocketTimeoutException e) {
            this.setStatus(Status.CONNECTION_TIMEOUT_ERROR);
            this.setError(e);
        }
        catch (Exception e) {
            this.setStatus(Status.ERROR);
            this.setError(e);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
            FileDownloader e = this;
            synchronized (e) {
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void setError(Exception e) {
        this.error = e;
    }

    public Exception getError() {
        return this.error;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETE;
    }

    public static enum Status {
        CONNECTING,
        CONNECTION_TIMEOUT_ERROR,
        DOWNLOADING,
        COMPLETE,
        CANCELLED,
        ERROR;

    }
}

