/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.legacy.PApplet;

public class CommandlineParser {
    private ACTION action = ACTION.GUI;
    private boolean doVerboseBuild = false;
    private boolean doVerboseUpload = false;
    private boolean doUseProgrammer = false;
    private boolean preserveTempFiles;
    private boolean noUploadPort = false;
    private boolean forceSavePrefs = false;
    private String getPref;
    private String boardToInstall;
    private String libraryToInstall;
    private List<String> filenames = new LinkedList<String>();

    public static CommandlineParser newCommandlineParser(String[] args) {
        return new CommandlineParser(args);
    }

    private CommandlineParser(String[] args) {
        this.parseArguments(args);
        this.checkAction();
    }

    private void parseArguments(String[] args) {
        HashMap<String, ACTION> actions = new HashMap<String, ACTION>();
        actions.put("--verify", ACTION.VERIFY);
        actions.put("--upload", ACTION.UPLOAD);
        actions.put("--get-pref", ACTION.GET_PREF);
        actions.put("--install-boards", ACTION.INSTALL_BOARD);
        actions.put("--install-library", ACTION.INSTALL_LIBRARY);
        for (int i = 0; i < args.length; ++i) {
            ACTION a = (ACTION)((Object)actions.get(args[i]));
            if (a != null) {
                if (this.action != ACTION.GUI && this.action != ACTION.NOOP) {
                    String[] valid = actions.keySet().toArray(new String[0]);
                    String mess = I18n.format(I18n._("Can only pass one of: {0}"), PApplet.join(valid, ", "));
                    BaseNoGui.showError(null, mess, 3);
                }
                if (a == ACTION.GET_PREF) {
                    if (++i >= args.length) {
                        BaseNoGui.showError(null, I18n.format(I18n._("Argument required for {0}"), a.value), 3);
                    }
                    this.getPref = args[i];
                }
                if (a == ACTION.INSTALL_BOARD) {
                    if (++i >= args.length) {
                        BaseNoGui.showError(null, I18n.format(I18n._("Argument required for {0}"), a.value), 3);
                    }
                    this.boardToInstall = args[i];
                }
                if (a == ACTION.INSTALL_LIBRARY) {
                    if (++i >= args.length) {
                        BaseNoGui.showError(null, I18n.format(I18n._("Argument required for {0}"), a.value), 3);
                    }
                    this.libraryToInstall = args[i];
                }
                this.action = a;
                continue;
            }
            if (args[i].startsWith("-psn")) continue;
            if (args[i].equals("--verbose") || args[i].equals("-v")) {
                this.doVerboseBuild = true;
                this.doVerboseUpload = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--preserve-temp-files")) {
                this.preserveTempFiles = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--verbose-build")) {
                this.doVerboseBuild = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--verbose-upload")) {
                this.doVerboseUpload = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--useprogrammer")) {
                this.doUseProgrammer = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--nouploadport")) {
                this.noUploadPort = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--board")) {
                if (++i >= args.length) {
                    BaseNoGui.showError(null, I18n._("Argument required for --board"), 3);
                }
                this.processBoardArgument(args[i]);
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--port")) {
                if (++i >= args.length) {
                    BaseNoGui.showError(null, I18n._("Argument required for --port"), 3);
                }
                BaseNoGui.selectSerialPort(args[i]);
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--curdir")) {
                if (++i < args.length) continue;
                BaseNoGui.showError(null, I18n._("Argument required for --curdir"), 3);
                continue;
            }
            if (args[i].equals("--buildpath")) {
                File buildFolder;
                if (++i >= args.length) {
                    BaseNoGui.showError(null, "Argument required for --buildpath", 3);
                }
                if (!(buildFolder = new File(args[i])).exists()) {
                    BaseNoGui.showError(null, "The build path doesn't exist", 3);
                }
                if (!buildFolder.isDirectory()) {
                    BaseNoGui.showError(null, "The build path is not a folder", 3);
                }
                BaseNoGui.setBuildFolder(buildFolder);
                continue;
            }
            if (args[i].equals("--pref")) {
                if (++i >= args.length) {
                    BaseNoGui.showError(null, I18n._("Argument required for --pref"), 3);
                }
                this.processPrefArgument(args[i]);
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (args[i].equals("--save-prefs")) {
                this.forceSavePrefs = true;
                continue;
            }
            if (args[i].equals("--preferences-file")) {
                if (++i < args.length) continue;
                BaseNoGui.showError(null, I18n._("Argument required for --preferences-file"), 3);
                continue;
            }
            if (args[i].startsWith("--")) {
                BaseNoGui.showError(null, I18n.format(I18n._("unknown option: {0}"), args[i]), 3);
            }
            this.filenames.add(args[i]);
        }
    }

    private void checkAction() {
        if ((this.action == ACTION.UPLOAD || this.action == ACTION.VERIFY) && this.filenames.size() != 1) {
            BaseNoGui.showError(null, I18n._("Must specify exactly one sketch file"), 3);
        }
        if ((this.action == ACTION.NOOP || this.action == ACTION.GET_PREF) && this.filenames.size() != 0) {
            BaseNoGui.showError(null, I18n._("Cannot specify any sketch files"), 3);
        }
        if (this.action != ACTION.UPLOAD && this.action != ACTION.VERIFY && (this.doVerboseBuild || this.doVerboseUpload)) {
            BaseNoGui.showError(null, I18n._("--verbose, --verbose-upload and --verbose-build can only be used together with --verify or --upload"), 3);
        }
    }

    private void processBoardArgument(String selectBoard) {
        TargetBoard targetBoard;
        TargetPlatform targetPlatform;
        TargetPackage targetPackage;
        if (selectBoard == null) {
            return;
        }
        String[] split = selectBoard.split(":", 4);
        if (split.length < 3) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid board name, it should be of the form \"package:arch:board\" or \"package:arch:board:options\""), selectBoard), 3);
        }
        if ((targetPackage = BaseNoGui.getTargetPackage(split[0])) == null) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Unknown package"), split[0]), 3);
        }
        if ((targetPlatform = targetPackage.get(split[1])) == null) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Unknown architecture"), split[1]), 3);
        }
        if ((targetBoard = targetPlatform.getBoard(split[2])) == null) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Unknown board"), split[2]), 3);
        }
        BaseNoGui.selectBoard(targetBoard);
        if (split.length > 3) {
            String[] options;
            for (String option : options = split[3].split(",")) {
                String[] keyValue = option.split("=", 2);
                if (keyValue.length != 2) {
                    BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid option, should be of the form \"name=value\""), option, targetBoard.getId()), 3);
                }
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                if (!targetBoard.hasMenu(key)) {
                    BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid option for board \"{1}\""), key, targetBoard.getId()), 3);
                }
                if (targetBoard.getMenuLabel(key, value) == null) {
                    BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid option for \"{1}\" option for board \"{2}\""), value, key, targetBoard.getId()), 3);
                }
                PreferencesData.set("custom_" + key, targetBoard.getId() + "_" + value);
            }
        }
    }

    private void processPrefArgument(String arg) {
        String[] split = arg.split("=", 2);
        if (split.length != 2 || split[0].isEmpty()) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid argument to --pref, should be of the form \"pref=value\""), arg), 3);
        }
        PreferencesData.set(split[0], split[1]);
    }

    public boolean isDoVerboseBuild() {
        return this.doVerboseBuild;
    }

    public boolean isDoVerboseUpload() {
        return this.doVerboseUpload;
    }

    public boolean isForceSavePrefs() {
        return this.forceSavePrefs;
    }

    public String getGetPref() {
        return this.getPref;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public boolean isGetPrefMode() {
        return this.action == ACTION.GET_PREF;
    }

    public boolean isGuiMode() {
        return this.action == ACTION.GUI;
    }

    public boolean isNoOpMode() {
        return this.action == ACTION.NOOP;
    }

    public boolean isUploadMode() {
        return this.action == ACTION.UPLOAD;
    }

    public boolean isVerifyMode() {
        return this.action == ACTION.VERIFY;
    }

    public boolean isVerifyOrUploadMode() {
        return this.isVerifyMode() || this.isUploadMode();
    }

    public boolean isDoUseProgrammer() {
        return this.doUseProgrammer;
    }

    public boolean isNoUploadPort() {
        return this.noUploadPort;
    }

    public boolean isInstallBoard() {
        return this.action == ACTION.INSTALL_BOARD;
    }

    public boolean isInstallLibrary() {
        return this.action == ACTION.INSTALL_LIBRARY;
    }

    public String getBoardToInstall() {
        return this.boardToInstall;
    }

    public String getLibraryToInstall() {
        return this.libraryToInstall;
    }

    public boolean isPreserveTempFiles() {
        return this.preserveTempFiles;
    }

    private static enum ACTION {
        GUI,
        NOOP,
        VERIFY("--verify"),
        UPLOAD("--upload"),
        GET_PREF("--get-pref"),
        INSTALL_BOARD("--install-boards"),
        INSTALL_LIBRARY("--install-library");

        private final String value;

        private ACTION() {
            this.value = null;
        }

        private ACTION(String value) {
            this.value = value;
        }
    }
}

