/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.ContributedLibraryReference;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;

public class UserLibrary
extends ContributedLibrary {
    private String name;
    private String version;
    private String author;
    private String maintainer;
    private String sentence;
    private String paragraph;
    private String website;
    private String category;
    private String license;
    private List<String> architectures;
    private List<String> types;
    private List<String> declaredTypes;
    private static final List<String> MANDATORY_PROPERTIES = Arrays.asList("name", "version", "author", "maintainer", "sentence", "paragraph", "url");
    private static final List<String> CATEGORIES = Arrays.asList("Display", "Communication", "Signal Input/Output", "Sensors", "Device Control", "Timing", "Data Storage", "Data Processing", "Other", "Uncategorized");
    protected LibraryLayout layout;

    public static UserLibrary create(File libFolder) throws IOException {
        String types;
        String license;
        LibraryLayout layout;
        File archFolder;
        File propertiesFile = new File(libFolder, "library.properties");
        PreferencesMap properties = new PreferencesMap();
        properties.load(propertiesFile);
        if (!properties.containsKey("maintainer") && properties.containsKey("email")) {
            properties.put("maintainer", properties.get("email"));
        }
        if ((archFolder = new File(libFolder, "arch")).isDirectory()) {
            throw new IOException("'arch' folder is no longer supported! See http://goo.gl/gfFJzU for more information");
        }
        for (String p : MANDATORY_PROPERTIES) {
            if (properties.containsKey(p)) continue;
            throw new IOException("Missing '" + p + "' from library");
        }
        File srcFolder = new File(libFolder, "src");
        if (srcFolder.exists() && srcFolder.isDirectory()) {
            layout = LibraryLayout.RECURSIVE;
            File utilFolder = new File(libFolder, "utility");
            if (utilFolder.exists() && utilFolder.isDirectory()) {
                throw new IOException("Library can't use both 'src' and 'utility' folders.");
            }
        } else {
            layout = LibraryLayout.FLAT;
        }
        for (File file : libFolder.listFiles()) {
            if (!file.isDirectory() || !FileUtils.isSCCSOrHiddenFile(file)) continue;
            System.out.println("WARNING: Spurious " + file.getName() + " folder in '" + (String)properties.get("name") + "' library");
        }
        String architectures = (String)properties.get("architectures");
        if (architectures == null) {
            architectures = "*";
        }
        ArrayList<String> archs = new ArrayList<String>();
        for (String arch : architectures.split(",")) {
            archs.add(arch.trim());
        }
        String category = (String)properties.get("category");
        if (category == null) {
            category = "Uncategorized";
        }
        if (!CATEGORIES.contains(category)) {
            category = "Uncategorized";
            System.out.println("WARNING: Category '" + category + "' in library " + (String)properties.get("name") + " is not valid. Setting to 'Uncategorized'");
        }
        if ((license = (String)properties.get("license")) == null) {
            license = "Unspecified";
        }
        if ((types = (String)properties.get("types")) == null) {
            types = "Contributed";
        }
        LinkedList<String> typesList = new LinkedList<String>();
        for (String type : types.split(",")) {
            typesList.add(type.trim());
        }
        UserLibrary res = new UserLibrary();
        res.setInstalledFolder(libFolder);
        res.setInstalled(true);
        res.name = ((String)properties.get("name")).trim();
        res.version = ((String)properties.get("version")).trim();
        res.author = ((String)properties.get("author")).trim();
        res.maintainer = ((String)properties.get("maintainer")).trim();
        res.sentence = ((String)properties.get("sentence")).trim();
        res.paragraph = ((String)properties.get("paragraph")).trim();
        res.website = ((String)properties.get("url")).trim();
        res.category = category.trim();
        res.license = license.trim();
        res.architectures = archs;
        res.layout = layout;
        res.declaredTypes = typesList;
        return res;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getArchitectures() {
        return this.architectures;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getParagraph() {
        return this.paragraph;
    }

    @Override
    public String getSentence() {
        return this.sentence;
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    public static List<String> getCategories() {
        return CATEGORIES;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getMaintainer() {
        return this.maintainer;
    }

    @Override
    public String getChecksum() {
        return null;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    public String getArchiveFileName() {
        return null;
    }

    @Override
    public List<ContributedLibraryReference> getRequires() {
        return null;
    }

    public List<String> getDeclaredTypes() {
        return this.declaredTypes;
    }

    public File getSrcFolder() {
        switch (this.layout) {
            case FLAT: {
                return this.getInstalledFolder();
            }
            case RECURSIVE: {
                return new File(this.getInstalledFolder(), "src");
            }
        }
        return null;
    }

    public boolean useRecursion() {
        return this.layout == LibraryLayout.RECURSIVE;
    }

    @Override
    public String toString() {
        String res = "Library: " + this.name + "\n";
        res = res + "         (version=" + this.version + ")\n";
        res = res + "         (author=" + this.author + ")\n";
        res = res + "         (maintainer=" + this.maintainer + ")\n";
        res = res + "         (sentence=" + this.sentence + ")\n";
        res = res + "         (paragraph=" + this.paragraph + ")\n";
        res = res + "         (url=" + this.website + ")\n";
        res = res + "         (architectures=" + this.architectures + ")\n";
        return res;
    }

    protected static enum LibraryLayout {
        FLAT,
        RECURSIVE;

    }
}

