/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.packages.DownloadableContribution;
import cc.arduino.contributions.packages.HostDependentDownloadableContribution;
import java.util.List;
import processing.app.BaseNoGui;

public abstract class ContributedTool {
    public abstract String getName();

    public abstract String getVersion();

    public abstract List<HostDependentDownloadableContribution> getSystems();

    public DownloadableContribution getDownloadableContribution() {
        for (HostDependentDownloadableContribution c : this.getSystems()) {
            if (!c.isCompatible(BaseNoGui.getPlatform())) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        String res = "Tool name : " + this.getName() + " " + this.getVersion() + "\n";
        for (HostDependentDownloadableContribution sys : this.getSystems()) {
            res = res + "     sys";
            res = res + (sys.isCompatible(BaseNoGui.getPlatform()) ? "*" : " ");
            res = res + " : " + sys + "\n";
        }
        return res;
    }
}

