/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="sun.nio.ch.ServerSocketChannelImpl")
public final class ServerSocketChannelImplRMHooks {
    private static NativeDispatcher nd;

    @InstrumentationMethod
    public SocketAddress getLocalAddress() throws IOException {
        return this.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public SocketChannel accept() throws IOException {
        SocketChannel socketChannel;
        block11: {
            long l = 0L;
            long l2 = 0L;
            socketChannel = null;
            ResourceIdImpl resourceIdImpl = null;
            ResourceRequest resourceRequest = null;
            try {
                socketChannel = this.accept();
                if (socketChannel != null) {
                    block10: {
                        resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(socketChannel);
                        resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
                        try {
                            l = resourceRequest.request(1L, resourceIdImpl);
                            if (l >= 1L) break block10;
                            try {
                                socketChannel.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw new IOException("Resource limited: too many open socket channels");
                        }
                        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                            try {
                                socketChannel.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw new IOException("Resource limited: too many open socket channels", resourceRequestDeniedException);
                        }
                    }
                    l2 = 1L;
                }
                if (resourceRequest == null) break block11;
                resourceRequest.request(-(l - l2), resourceIdImpl);
            }
            catch (Throwable throwable) {
                if (resourceRequest != null) {
                    resourceRequest.request(-(l - l2), resourceIdImpl);
                }
                throw throwable;
            }
        }
        return socketChannel;
    }

    public final void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private int accept(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, InetSocketAddress[] inetSocketAddressArray) throws IOException {
        int n = this.accept(fileDescriptor, fileDescriptor2, inetSocketAddressArray);
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(fileDescriptor2);
        if (resourceIdImpl != null) {
            ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor2);
            long l = 0L;
            long l2 = 0L;
            try {
                try {
                    l = resourceRequest.request(1L, resourceIdImpl);
                    if (l < 1L) {
                        throw new IOException("Resource limited: too many open file descriptors");
                    }
                }
                catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                    throw new IOException("Resource limited: too many open file descriptors", resourceRequestDeniedException);
                }
                l2 = 1L;
            }
            finally {
                if (l2 == 0L) {
                    try {
                        nd.close(fileDescriptor2);
                    }
                    catch (IOException iOException) {}
                } else {
                    resourceRequest.request(-(l - 1L), resourceIdImpl);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public ServerSocketChannel bind(SocketAddress socketAddress, int n) throws IOException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (this.getLocalAddress() == null) {
            resourceIdImpl = ResourceIdImpl.of(socketAddress);
            resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many open socket channels");
            }
        }
        int n2 = 0;
        ServerSocketChannel serverSocketChannel = null;
        try {
            serverSocketChannel = this.bind(socketAddress, n);
            n2 = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n2), resourceIdImpl);
            }
        }
        return serverSocketChannel;
    }

    abstract class NativeDispatcher {
        NativeDispatcher() {
        }

        abstract void close(FileDescriptor var1) throws IOException;
    }
}

