/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaTabbedPaneUI;
import java.awt.Dimension;
import java.awt.Rectangle;

class AquaTabbedPaneTabState {
    static final int FIXED_SCROLL_TAB_LENGTH = 27;
    protected final Rectangle leftScrollTabRect = new Rectangle();
    protected final Rectangle rightScrollTabRect = new Rectangle();
    protected int numberOfVisibleTabs = 0;
    protected int[] visibleTabList = new int[10];
    protected int lastLeftmostTab;
    protected int lastReturnAt;
    private boolean needsScrollers;
    private boolean hasMoreLeftTabs;
    private boolean hasMoreRightTabs;
    private final AquaTabbedPaneUI pane;

    protected AquaTabbedPaneTabState(AquaTabbedPaneUI aquaTabbedPaneUI) {
        this.pane = aquaTabbedPaneUI;
    }

    protected int getIndex(int n) {
        if (n >= this.visibleTabList.length) {
            return Integer.MIN_VALUE;
        }
        return this.visibleTabList[n];
    }

    protected void init(int n) {
        if (n < 1) {
            this.needsScrollers = false;
        }
        if (n == this.visibleTabList.length) {
            return;
        }
        int[] nArray = new int[n];
        System.arraycopy(this.visibleTabList, 0, nArray, 0, Math.min(this.visibleTabList.length, n));
        this.visibleTabList = nArray;
    }

    int getTotal() {
        return this.numberOfVisibleTabs;
    }

    boolean needsScrollTabs() {
        return this.needsScrollers;
    }

    void setNeedsScrollers(boolean bl) {
        this.needsScrollers = bl;
    }

    boolean needsLeftScrollTab() {
        return this.hasMoreLeftTabs;
    }

    boolean needsRightScrollTab() {
        return this.hasMoreRightTabs;
    }

    Rectangle getLeftScrollTabRect() {
        return this.leftScrollTabRect;
    }

    Rectangle getRightScrollTabRect() {
        return this.rightScrollTabRect;
    }

    boolean isBefore(int n) {
        if (this.numberOfVisibleTabs == 0) {
            return true;
        }
        return n < this.visibleTabList[0];
    }

    boolean isAfter(int n) {
        return n > this.visibleTabList[this.numberOfVisibleTabs - 1];
    }

    private void addToEnd(int n, int n2) {
        this.visibleTabList[n2] = n;
    }

    private void addToBeginning(int n, int n2) {
        System.arraycopy(this.visibleTabList, 0, this.visibleTabList, 1, n2);
        this.visibleTabList[0] = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    void relayoutForScrolling(Rectangle[] rectangleArray, int n, int n2, int n3, int n4, boolean bl, int n5, boolean bl2) {
        int n6;
        int n7;
        boolean bl3;
        if (!this.needsScrollers) {
            this.hasMoreLeftTabs = false;
            this.hasMoreRightTabs = false;
            return;
        }
        if (bl) {
            this.rightScrollTabRect.height = 27;
            this.leftScrollTabRect.height = 27;
        } else {
            this.rightScrollTabRect.width = 27;
            this.leftScrollTabRect.width = 27;
        }
        boolean bl4 = bl3 = n3 != this.lastReturnAt;
        if (this.pane.popupSelectionChanged || bl3) {
            this.pane.popupSelectionChanged = false;
            this.lastLeftmostTab = -1;
        }
        int n8 = n4;
        int n9 = n4 - 1;
        if (this.lastLeftmostTab >= 0) {
            n8 = this.lastLeftmostTab;
            n9 = -1;
        } else if (n4 < 0) {
            n8 = 0;
            n9 = -1;
        }
        int n10 = n3 - this.pane.tabAreaInsets.right - this.pane.tabAreaInsets.left - 54;
        int n11 = 0;
        Rectangle rectangle = rectangleArray[n8];
        if ((bl ? rectangle.height : rectangle.width) > n10) {
            this.addToEnd(n8, n11);
            if (bl) {
                rectangle.height = n10;
            } else {
                rectangle.width = n10;
            }
            ++n11;
        } else {
            n7 = 0;
            n6 = 0;
            while (n11 < n5 && (n7 == 0 || n6 == 0)) {
                Rectangle rectangle2;
                block21: {
                    if (n7 == 0 && n8 >= 0 && n8 < n5) {
                        rectangle2 = rectangleArray[n8];
                        if ((bl ? rectangle2.height : rectangle2.width) > n10) {
                            n7 = 1;
                            break block21;
                        } else {
                            this.addToEnd(n8, n11);
                            ++n11;
                            n10 -= bl ? rectangle2.height : rectangle2.width;
                            ++n8;
                            continue;
                        }
                    }
                    n7 = 1;
                }
                if (n6 == 0 && n9 >= 0 && n9 < n5) {
                    rectangle2 = rectangleArray[n9];
                    if ((bl ? rectangle2.height : rectangle2.width) > n10) {
                        n6 = 1;
                        continue;
                    }
                    this.addToBeginning(n9, n11);
                    ++n11;
                    n10 -= bl ? rectangle2.height : rectangle2.width;
                    --n9;
                    continue;
                }
                n6 = 1;
            }
        }
        if (n11 > this.visibleTabList.length) {
            n11 = this.visibleTabList.length;
        }
        this.hasMoreLeftTabs = this.visibleTabList[0] > 0;
        this.hasMoreRightTabs = this.visibleTabList[n11 - 1] < this.visibleTabList.length - 1;
        this.numberOfVisibleTabs = n11;
        this.lastLeftmostTab = this.getIndex(0);
        this.lastReturnAt = n3;
        n7 = this.getIndex(0);
        n6 = this.getIndex(n11 - 1);
        int n12 = 0;
        while (n12 < n5) {
            if (n12 < n7 || n12 > n6) {
                Rectangle rectangle3 = rectangleArray[n12];
                rectangle3.x = Short.MAX_VALUE;
                rectangle3.y = Short.MAX_VALUE;
            }
            ++n12;
        }
        return;
    }

    protected void alignRectsRunFor(Rectangle[] rectangleArray, Dimension dimension, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = n == 2 || n == 4;
        if (bl2) {
            if (this.needsScrollers) {
                this.stretchScrollingVerticalRun(rectangleArray, dimension);
            } else {
                this.centerVerticalRun(rectangleArray, dimension);
            }
        } else if (this.needsScrollers) {
            this.stretchScrollingHorizontalRun(rectangleArray, dimension, bl);
        } else {
            this.centerHorizontalRun(rectangleArray, dimension, bl);
        }
    }

    private void centerHorizontalRun(Rectangle[] rectangleArray, Dimension dimension, boolean bl) {
        int n = 0;
        Rectangle[] rectangleArray2 = rectangleArray;
        int n2 = rectangleArray2.length;
        for (int i = 0; i < n2; ++i) {
            Rectangle rectangle = rectangleArray2[i];
            n += rectangle.width;
        }
        int n3 = dimension.width / 2 - n / 2;
        if (bl) {
            for (Rectangle rectangle : rectangleArray) {
                rectangle.x = n3;
                n3 += rectangle.width;
            }
        } else {
            for (n2 = rectangleArray.length - 1; n2 >= 0; --n2) {
                Rectangle rectangle = rectangleArray[n2];
                rectangle.x = n3;
                n3 += rectangle.width;
            }
        }
    }

    private void centerVerticalRun(Rectangle[] rectangleArray, Dimension dimension) {
        int n = 0;
        for (Rectangle rectangle : rectangleArray) {
            n += rectangle.height;
        }
        int n2 = dimension.height / 2 - n / 2;
        for (Rectangle rectangle : rectangleArray) {
            rectangle.y = n2;
            n2 += rectangle.height;
        }
    }

    private void stretchScrollingHorizontalRun(Rectangle[] rectangleArray, Dimension dimension, boolean bl) {
        int n;
        Rectangle rectangle;
        int n2;
        int n3;
        int n4 = this.getTotal();
        int n5 = this.getIndex(0);
        int n6 = this.getIndex(n4 - 1);
        int n7 = 0;
        for (n3 = n5; n3 <= n6; ++n3) {
            n7 += rectangleArray[n3].width;
        }
        n3 = dimension.width - n7 - this.pane.tabAreaInsets.left - this.pane.tabAreaInsets.right;
        if (this.needsLeftScrollTab()) {
            n3 -= 27;
        }
        if (this.needsRightScrollTab()) {
            n3 -= 27;
        }
        int n8 = (int)((float)n3 / (float)n4);
        int n9 = n3 - n8 * n4;
        int n10 = 0;
        int n11 = this.pane.tabAreaInsets.left + (this.needsLeftScrollTab() ? 27 : 0);
        if (bl) {
            for (n2 = n5; n2 <= n6; ++n2) {
                rectangle = rectangleArray[n2];
                n = n8;
                if (n9 > 0) {
                    ++n;
                    --n9;
                }
                rectangle.x = n10 + n11;
                rectangle.width += n;
                n10 += rectangle.width;
            }
        } else {
            for (n2 = n6; n2 >= n5; --n2) {
                rectangle = rectangleArray[n2];
                n = n8;
                if (n9 > 0) {
                    ++n;
                    --n9;
                }
                rectangle.x = n10 + n11;
                rectangle.width += n;
                n10 += rectangle.width;
            }
        }
        if (bl) {
            this.leftScrollTabRect.x = this.pane.tabAreaInsets.left;
            this.leftScrollTabRect.y = rectangleArray[n5].y;
            this.leftScrollTabRect.height = rectangleArray[n5].height;
            this.rightScrollTabRect.x = dimension.width - this.pane.tabAreaInsets.right - this.rightScrollTabRect.width;
            this.rightScrollTabRect.y = rectangleArray[n6].y;
            this.rightScrollTabRect.height = rectangleArray[n6].height;
        } else {
            this.rightScrollTabRect.x = this.pane.tabAreaInsets.left;
            this.rightScrollTabRect.y = rectangleArray[n5].y;
            this.rightScrollTabRect.height = rectangleArray[n5].height;
            this.leftScrollTabRect.x = dimension.width - this.pane.tabAreaInsets.right - this.rightScrollTabRect.width;
            this.leftScrollTabRect.y = rectangleArray[n6].y;
            this.leftScrollTabRect.height = rectangleArray[n6].height;
            if (this.needsLeftScrollTab()) {
                for (n2 = n6; n2 >= n5; --n2) {
                    rectangle = rectangleArray[n2];
                    rectangle.x -= 27;
                }
            }
            if (this.needsRightScrollTab()) {
                for (n2 = n6; n2 >= n5; --n2) {
                    rectangle = rectangleArray[n2];
                    rectangle.x += 27;
                }
            }
        }
    }

    private void stretchScrollingVerticalRun(Rectangle[] rectangleArray, Dimension dimension) {
        int n;
        int n2 = this.getTotal();
        int n3 = this.getIndex(0);
        int n4 = this.getIndex(n2 - 1);
        int n5 = 0;
        for (n = n3; n <= n4; ++n) {
            n5 += rectangleArray[n].height;
        }
        n = dimension.height - n5 - this.pane.tabAreaInsets.top - this.pane.tabAreaInsets.bottom;
        if (this.needsLeftScrollTab()) {
            n -= 27;
        }
        if (this.needsRightScrollTab()) {
            n -= 27;
        }
        int n6 = (int)((float)n / (float)n2);
        int n7 = n - n6 * n2;
        int n8 = 0;
        int n9 = this.pane.tabAreaInsets.top + (this.needsLeftScrollTab() ? 27 : 0);
        for (int i = n3; i <= n4; ++i) {
            Rectangle rectangle = rectangleArray[i];
            int n10 = n6;
            if (n7 > 0) {
                ++n10;
                --n7;
            }
            rectangle.y = n8 + n9;
            rectangle.height += n10;
            n8 += rectangle.height;
        }
        this.leftScrollTabRect.x = rectangleArray[n3].x;
        this.leftScrollTabRect.y = this.pane.tabAreaInsets.top;
        this.leftScrollTabRect.width = rectangleArray[n3].width;
        this.rightScrollTabRect.x = rectangleArray[n4].x;
        this.rightScrollTabRect.y = dimension.height - this.pane.tabAreaInsets.bottom - this.rightScrollTabRect.height;
        this.rightScrollTabRect.width = rectangleArray[n4].width;
    }
}

