﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CSharpTeach
{
    public partial class Form1 : Form
    {
        /*-----以下為全域變數-----*/
        private const int VIEW_H = 600;//螢幕高
        private const int VIEW_W = 800;//螢幕寬
        private const int DATA_VIEW_H = 100;//資料列高
        private const int DATA_VIEW_W = VIEW_W;//資料列寬
        private const int DRAW_VIEW_H = VIEW_H - DATA_VIEW_H;//畫布高
        private const int DRAW_VIEW_W = VIEW_W;//畫布長寬

        private Graphics wndGraphics;//視窗畫布
        /*-----以上為全域變數-----*/
        public Form1()
        {
            InitializeComponent();
            wndGraphics = this.CreateGraphics();//建立視窗畫布
        }


        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            wndGraphics.DrawLine(Pens.Black, 0, DATA_VIEW_H, DATA_VIEW_W, DATA_VIEW_H);//畫出分隔線
        }

        private void button1_Click(object sender, EventArgs e)//當按下確定按鈕之後要做的事情
        {
            clear();//先清理畫面
            DrawRect(Convert.ToInt32(textBox1.Text), DATA_VIEW_H + Convert.ToInt32(textBox2.Text), Convert.ToInt32(textBox3.Text), Convert.ToInt32(textBox4.Text));
            //呼叫function，遞迴的run。textBox1.Text為第一個input的資料。Convert.ToInt32為轉化文字為int。
        }

        private void DrawRect(int startX, int startY,int size, int order)
        {
            Pen aPen = new Pen(Color.Black, 1);//建立一支筆，顏色為黑，寬度為1
            wndGraphics.DrawRectangle(aPen, startX, startY, size, size);//畫外框(矩形)
            wndGraphics.FillRectangle(Brushes.Red, startX+size/3, startY+size/3, size/3, size/3);//畫一個被填滿的矩形(無外框)
            if (order > 1)//使用遞迴的方式做畫圖
            {
                order--;
                DrawRect(startX, startY, size / 3, order);
                DrawRect(startX + size / 3, startY, size / 3, order);
                DrawRect(startX + size * 2 / 3, startY, size / 3, order);
                DrawRect(startX, startY + size / 3, size / 3, order);
                DrawRect(startX + size * 2 / 3, startY + size / 3, size / 3, order);
                DrawRect(startX, startY + size * 2 / 3, size / 3, order);
                DrawRect(startX + size / 3, startY + size * 2 / 3, size / 3, order);
                DrawRect(startX + size * 2 / 3, startY + size * 2 / 3, size / 3, order);
            }
        }

        private void clear()
        {
            wndGraphics.FillRectangle(Brushes.White, 0, 0, VIEW_W, VIEW_H);//清除畫面，直接填滿白色
        }
    }
}
