function init()
{
    var xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
    var node;
    xmlDoc.async = false;
    xmlDoc.load("file.xml");
    
    var title, note;
    var header = {item: "", title: "", note: "", size: ""};
    
    
    title = makehtml(xmlDoc.documentElement.selectSingleNode("title").text);
    note = makehtml(xmlDoc.documentElement.selectSingleNode("note").text)

    document.getElementById("title").innerHTML = title;
    document.title = title;
    document.getElementById("note").innerHTML = note;
    
    node = xmlDoc.documentElement.selectSingleNode("header");
    header.item = makehtml(node.selectSingleNode("item").text);
    header.name = makehtml(node.selectSingleNode("name").text);
    header.note  = makehtml(node.selectSingleNode("note").text);
    header.size  = makehtml(node.selectSingleNode("size").text);
    
    var t = {name: "data", header: "", data: [], align: []};
    t.header = [
        [header.item, "30"],
        [header.name, "200"],
        [header.note, "0"],
        [header.size, "60"]
    ];
    t.align = ["", "center", "left", "left", "right"]; 
    
    node = xmlDoc.documentElement.selectSingleNode("list");
    for (i=0; i<node.childNodes.length; i++)
    {
        var name, note, size;
        name = makehtml(node.childNodes[i].selectSingleNode("name").text);
        note = makehtml(node.childNodes[i].selectSingleNode("note").text);
        size = makehtml(node.childNodes[i].selectSingleNode("size").text);
        t.data[i] = [i, i+1, "<a href='files/" + name + "' target=_blank>" + name + "</a>", note, size];
    }
    
    var table = new dom.table(t);
    document.getElementById(t.name).appendChild(table.obj);
}


var dom = new Object();
dom.table = function(tbl)
{
    this.obj = document.createElement("TABLE");
    this.oTBody = document.createElement("TBODY");
    this.obj.appendChild(this.oTBody);
    this.obj.cellSpacing = 1;
    this.obj.className = "list";
      
    this.setHeader(tbl.header);
    for (j=0; j<tbl.data.length; j++)
    {
        this.insertRow(tbl.data[j], tbl.align);
    }  
}
dom.table.prototype = {
    setHeader: function(ary)
    {
        var tr = document.createElement("TR");
        this.oTBody.appendChild(tr);
        for (var i=0; i<ary.length; i++)
        {
            var td = document.createElement("TD");
            if (ary[i][1] != 0) td.style.width = ary[i][1] + "px";
            td.innerHTML = ary[i][0];
            td.className = "header";
            tr.appendChild(td);
        }
    },
    
    insertRow: function(ary, align)
    {
        var tr = document.createElement("TR");
        tr.id = ary[0];
        tr.onclick = this.onClick;
        tr.onmouseover = this.onMouseOver;
        tr.onmouseout = this.onMouseOut;
        this.oTBody.appendChild(tr);
        
        for (var i=1; i<ary.length; i++)
        {
            var td = document.createElement("TD");
            td.className = "data";
            td.align = align[i];
            td.innerHTML = ary[i];
            tr.appendChild(td);
        }
    },
    
    onClick: function()
    {
        // alert("click: " + this.id);
    },
    
    onMouseOver: function()
    {
        this.className = "over";
    },
    
    onMouseOut: function()
    {
        this.className = "out";
    }
}


function makehtml(text)
{
    var html = text.replace(/&/,"&amp;");
    html = html.replace(/</,"&lt;");
    html = html.replace(/>/,"&gt;");
    html = html.replace(/\r\n/,"<br>");
    html = html.replace(/\n/,"<br>");
    html = html.replace(/\r/,"<br>");
    return(html);
}